#include <iostream>
#include <vector>
#include <set>
using namespace std;

void azuriraj_greske(set<int>& greske, const vector<int>& niz, int indeks, int n) {
    if (indeks > 0 && indeks < n) {
        if (niz[indeks - 1] > niz[indeks]) {
            greske.insert(indeks - 1);
        } else {
            greske.erase(indeks - 1);
        }
    }
    if (indeks >= 0 && indeks < n - 1) {
        if (niz[indeks] > niz[indeks + 1]) {
            greske.insert(indeks);
        } else {
            greske.erase(indeks);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, broj_upita;
    cin >> n >> broj_upita;

    vector<int> niz(n);
    for (int i = 0; i < n; i++) {
        cin >> niz[i];
    }

    set<int> greske;
    for (int i = 0; i < n - 1; i++) {
        if (niz[i] > niz[i + 1]) {
            greske.insert(i);
        }
    }

    cout << greske.size() + 1 << "\n";

    for (int q = 0; q < broj_upita; q++) {
        int i, j;
        cin >> i >> j;
        i--, j--;

        azuriraj_greske(greske, niz, i, n);
        azuriraj_greske(greske, niz, j, n);

        swap(niz[i], niz[j]);

        azuriraj_greske(greske, niz, i, n);
        azuriraj_greske(greske, niz, j, n);

        cout << greske.size() + 1 << "\n";
    }

    return 0;
}